package com.jcg.example;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

import static org.junit.jupiter.api.Assertions.assertEquals;

@ExtendWith(SpringExtension.class)
@SpringBootTest(classes = MyTestConfig.class)
@TestPropertySource(locations = "classpath:test.properties")
public class MySpringBootTest {

    @Autowired
    private MyService myService;

    @Test
    public void testAppMessage() {
        String actualMessage = myService.getAppMessage();
        assertEquals("Hello from test.properties", actualMessage);
    }
}
